<?php

namespace App\Observers;

use App\Helpers;
use App\Models\InventoryMovement;
use App\Repositories\InventorySnapshotRepository;
use Illuminate\Database\Eloquent\Model;

/*
 * TODO: What if FIFO layer gets updated (could affect valuation).  We'd have to invalidate product days for all
 *  usages of said FIFO layer
 */
class InvalidateInventorySnapshotObserver
{
    private InventorySnapshotRepository $inventorySnapshotRepository;

    public function __construct()
    {
        $this->inventorySnapshotRepository = app(InventorySnapshotRepository::class);
    }

    public function created(Model $model): void
    {
        $this->handleInventoryMovement($model);
    }

    public function updated(Model $model): void
    {
        $this->handleInventoryMovement($model);
    }

    public function deleted(Model $model): void
    {
        $this->handleInventoryMovement($model);
    }

    public function handleInventoryMovement($model): void
    {
        // InventorySnapshot is not currently in use
        //        if ($model instanceof InventoryMovement)
        //        {
        //            $this->inventorySnapshotRepository->invalidateProductDate(
        //                $model->product_id,
        //                Helpers::utcStartOfLocalDate($model->inventory_movement_date)
        //            );
        //        }
    }
}
