<?php

namespace App\Observers;

use App\Models\FifoLayer;
use App\Models\InventoryAdjustment;
use App\Models\SalesCreditReturnLine;
use App\Models\StockTakeItem;

class FifoLayerUpdateObserver
{
    public function updated(FifoLayer $fifoLayer): void
    {
        if ($fifoLayer->link_type != 'initial_count') {
            if ($fifoLayer->link instanceof SalesCreditReturnLine)
            {
                $salesCreditReturn = $fifoLayer->link->salesCreditReturn;
                $salesCreditReturn->updated_at = now();
                $salesCreditReturn->save();
            } elseif ($fifoLayer->link instanceof InventoryAdjustment)
            {
                $inventoryAdjustment = $fifoLayer->link;
                $inventoryAdjustment->updated_at = now();
                $inventoryAdjustment->save();
            } elseif ($fifoLayer->link instanceof StockTakeItem)
            {
                $stockTakeItem = $fifoLayer->link->stockTake;
                $stockTakeItem->updated_at = now();
                $stockTakeItem->save();
            }
        }
    }
}
