<?php

namespace App\Notifications;

use App\Models\SalesOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class UncancellableVeracoreOrderNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(
        public SalesOrder $salesOrder,
        public string $note
    )
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $extraNote = "If Veracore does eventually cancel the fulfillment, 
        you should manually either trigger a sales channel refresh (if the sales channel refresh is supported) 
        or delete the fulfillment in SKUio.  If the Veracore fulfillment does not get cancelled, 
        the sales order will simply reflect a fulfillment which occurred in reality 
        (but the original sales channel order may not reflect this).";

        return (new MailMessage)
            ->subject("Cannot cancel Veracore Fulfillment for Sales Order #{$this->salesOrder->sales_order_number}")
            ->line("The automated fulfillment process for order #{$this->salesOrder->sales_order_number} has failed.")
            ->line("{$this->note}")
            ->line($extraNote)
            ->action('View Order',$this->salesOrder->getUrl())
            ->line('Thank you for using our SKUio!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
