<?php

namespace App\Notifications;

use App\Models\PurchaseOrder;
use App\Models\StoreEmailTemplate;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

/**
 * Class SubmitPurchaseOrderToSupplierNotification.
 *
 * NOTE: We can't extend this from TrackableJob, so we are duplicating functionality here
 */
class SubmitPurchaseOrderToSupplierNotification extends PurchaseOrderNotification implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;

    public function __construct(PurchaseOrder $purchaseOrder)
    {
        parent::__construct($purchaseOrder);
    }

    public function getTemplateType(): string
    {
        return StoreEmailTemplate::TYPE_PURCHASE_ORDER;
    }
}
