<?php

namespace App\Notifications;

use App\Models\SalesOrder;
use App\Models\StoreEmailTemplate;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

abstract class SalesOrderNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * @var SalesOrder
     */
    public $salesOrder;

    /**
     * SalesOrderApprovedNotification constructor.
     */
    public function __construct(SalesOrder $salesOrder)
    {
        $this->salesOrder = $salesOrder;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     */
    public function via($notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return MailMessage|void
     */
    public function toMail($notifiable): MailMessage|bool
    {
        $this->salesOrder->load([
            'customer',
            'salesOrderLines',
            'salesOrderLines.product',
            'store',
        ]);

        $emailTemplate = StoreEmailTemplate::with([])
//                                       ->where( 'store_id', $this->salesOrder->store_id )
            ->where('type', $this->getTemplateType())
            ->first();
        if (! $emailTemplate || ! $emailTemplate->enabled) {
            return false;
        }

        $data = StoreEmailTemplate::fillTemplate($this->salesOrder->id, 'SalesOrder', $emailTemplate->subject, $emailTemplate->html_body);

        // Markdown Email
        $mailMessage = new MailMessage();
        $mailMessage->from($this->salesOrder->store->email, $this->salesOrder->store->name);
        $mailMessage->bcc($this->salesOrder->store->email, $this->salesOrder->store->name);
        $mailMessage->subject($data['subject']);
        $mailMessage->view('mail.template', ['body' => $data['body']]);

        return $mailMessage;
    }

    abstract public function getTemplateType(): string;
}
