<?php

namespace App\Notifications;

use App\Models\PurchaseInvoice;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PurchaseInvoiceCreated extends Notification
{
    use Queueable;

    /**
     * @var PurchaseInvoice
     */
    public $purchaseInvoice;

    /**
     * Create a new notification instance.
     */
    public function __construct(PurchaseInvoice $purchaseInvoice)
    {
        $this->purchaseInvoice = $purchaseInvoice;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     */
    public function via($notifiable): array
    {
        return ['broadcast', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toMail($notifiable): MailMessage
    {
        return ( new MailMessage )
            ->greeting('Hello '.$notifiable->name.'!')
            ->subject('Purchase Invoice Created')
            ->line('Purchase invoice created for a purchase order.')
            ->action('View Purchase Order', url('/purchase-orders/'.$this->purchaseInvoice->purchase_order_id))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the broadcastable representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toBroadcast($notifiable): BroadcastMessage
    {
        return new BroadcastMessage([
            'title' => 'Purchase Invoice Created',
            'user' => auth()->user(),
            'url' => url('/purchase-orders/'.$this->purchaseInvoice->purchase_order_id),
        ]);
    }
}
