<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Storage;

class ProblemRecordsCsvNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected string $csvFilePath;
    protected string $description;

    public function __construct(string $csvFilePath, string $description)
    {
        $this->csvFilePath = $csvFilePath;
        $this->description = $description;
    }

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Problem Records CSV: ' . $this->description)
            ->line('See attached')
            ->attach($this->csvFilePath);
    }

    public function __destruct()
    {
        Storage::disk('export')->delete($this->csvFilePath);
    }
}
