<?php

namespace App\Notifications;

use App\Models\IntegrationInstance;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\SlackMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class IntegrationInstanceSyncStatusInactiveNotification extends Notification
{
    /**
     * Create a new notification instance.
     */
    public function __construct(private IntegrationInstance $integrationInstance)
    {
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return [
            'mail', //TODO: Enable after making emaail
            'slack',
        ];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->greeting("Dear {$notifiable->name},")
            ->subject('Urgent Action Required: Integration Authentication Failure of '.$this->integrationInstance->name.' on SKU.io')
            ->line('We are writing to inform you of an important issue that requires your immediate attention. Our monitoring systems have detected a failure in the authentication process for one of our third-party integrations within the SKU.io platform. This failure was specifically identified by a 403 HTTP status code received from the third-party API, indicating an authentication issue.')
            ->line(new HtmlString('<strong>Integration Affected: '.$this->integrationInstance->name.' Date and Time of Occurrence: '.now()->toDateTimeString().'</strong>'))
            ->line(new HtmlString('<strong>Impact:</strong>'))
            ->line('The integration has ceased functioning, which may affect certain features or data syncing processes within SKU.io.')
            ->line('To protect your data and system integrity, the system has automatically halted further authentication attempts.')
            ->line('Required Action: To restore the functionality of this integration, user intervention is necessary. Please follow these steps:')
            ->line('1. Log into your SKU.io account.')
            ->line('2. Navigate to the \'Integrations\' section.')
            ->line('3. Locate the affected integration and review the connection settings.')
            ->line('4. Update the authentication credentials or contact the integration provider for further guidance if necessary.')
            ->line('4. Update the authentication credentials or contact the integration provider for further guidance if necessary.')
            ->line(new HtmlString('<strong>Assistance:</strong> If you encounter any difficulties or have any questions, please do not hesitate to contact our support team at support@sku.io. Our team is ready to assist you in resolving this issue as quickly as possible.'))
            ->line(new HtmlString('<strong>Preventive Measures:</strong> We are actively investigating the root cause of this authentication failure and are implementing measures to prevent such occurrences in the future.'))
            ->line('We apologize for any inconvenience this may cause and thank you for your prompt attention to this matter. Ensuring the seamless operation of our platform and the satisfaction of our users is our top priority.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }

    public function toSlack($notifiable)
    {
        return (new SlackMessage)
            ->content('Integration instance '.$this->integrationInstance->id.' is Inactive')
            ->from('SKU.io');
    }
}
