<?php

namespace App\Models\WooCommerce;

use App\Integrations\WooCommerce;
use App\Models\SalesOrder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Order.
 *
 *
 * @property int $sku_sales_order_id
 * @property array $normalized_section
 * @property array $raw_order
 */
class Order extends Model
{
    protected $guarded = [];

    /**
     * Map eBay order Status with Local.
     * Return Local Status.
     */
    public static function statusMap($woo_commerce_object): string
    {
        switch ($woo_commerce_object['status']) {
            case WooCommerce::ORDER_STATUS_PENDING:
            case WooCommerce::ORDER_STATUS_FAILED:
                return SalesOrder::STATUS_DRAFT;
            case WooCommerce::ORDER_STATUS_PROCESSING:
            case WooCommerce::ORDER_STATUS_ON_HOLD:
                return SalesOrder::STATUS_OPEN;
            case WooCommerce::ORDER_STATUS_COMPLETED:
            case WooCommerce::ORDER_STATUS_CANCELLED:
            case WooCommerce::ORDER_STATUS_TRASH:
                return SalesOrder::STATUS_CLOSED;
            default:
                return SalesOrder::STATUS_DRAFT;
        }
    }
}
