<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class WarehouseLocation.
 *
 *
 * @property int $id
 * @property int $warehouse_id
 * @property string $aisle
 * @property string|null $bay
 * @property string|null $shelf
 * @property string|null $bin
 * @property bool $is_default
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class WarehouseLocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'warehouse_id',
        'aisle',
        'bay',
        'shelf',
        'bin',
        'is_default',
    ];

    protected $hidden = ['created_at', 'updated_at'];

    protected $casts = ['is_default' => 'boolean'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function inventoryMovements()
    {
        return $this->hasMany(InventoryMovement::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Functions
    |--------------------------------------------------------------------------
    */

    public function save(array $options = [])
    {
        if ($this->is_default) {
            // reset default location to warehouse
            if (($this->exists && ! $this->getOriginal('is_default')) || ! $this->exists) {
                self::with([])->where('warehouse_id', $this->warehouse_id)->update(['is_default' => false]);
            }
        }

        return parent::save($options);
    }
}
