<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class UserApi.
 *
 *
 * @property int $id
 * @property int $user_id
 * @property string $key
 * @property string $password
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class UserConfig extends Model
{
    protected $table = 'user_config';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function toArray()
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'key' => $this->key,
            'value' => $this->value,
        ];
    }
}
