<?php

namespace App\Models;

use Carbon\Carbon;
use Hash;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;

/**
 * Class UserApi.
 *
 *
 * @property int $id
 * @property int $user_id
 * @property string $name
 * @property string $key
 * @property string $password
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class UserApi extends Authenticatable
{
    use SoftDeletes;

    /**
     * Set guard to "basic".
     */
    protected $guard = 'basic';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'key',
        'password',
        'user_id',
    ];

    /**
     * Always load with model.
     *
     * @var array
     */
    protected $with = ['user'];

    /**
     * Hash a password before authentication.
     */
    public function getAuthPassword(): string
    {
        return Hash::make($this->password);
    }

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function toArray()
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'name' => $this->user->name,
            'email' => $this->user->email,
        ];
    }
}
