<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class UserAlert.
 *
 *
 * @property int $user_id
 * @property int $activity_log_id
 * @property int $priority
 * @property string $alert_type
 * @property bool $show_in_ui_notification
 * @property bool $alert_by_email
 * @property Carbon $read_at
 * @property Carbon $created_at
 */
class UserAlert extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'activity_log_id',
        'priority',
        'alert_type',
        'show_in_ui_notification',
        'alert_by_email',
        'read_at',
    ];

    protected $casts = [
        'read_at' => 'datetime',
    ];

    public function save(array $options = [])
    {
        /**
         * Set default value for "created_at" attribute.
         */
        if (empty($this->attributes['created_at'])) {
            $this->created_at = Carbon::now();
        }

        return parent::save($options);
    }

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
