<?php

namespace App\Models;

use App\Models\Concerns\HasFilters;
use App\Models\Concerns\HasSort;
use App\Models\Contracts\Filterable;
use App\Models\Contracts\Sortable;
use Illuminate\Support\Facades\DB;
use Spatie\Tags\Tag as SpatieTag;

class Tag extends SpatieTag implements Filterable, Sortable
{
    use HasFilters,
        HasSort;

    public function isUsed()
    {
        $count = DB::table('taggables')->where('tag_id', $this->id)->count();

        if ($count) {
            return [
                'tags' => trans_choice('messages.currently_used', $count, [
                    'resource' => 'items',
                    'model' => 'Tag('.$this->name.')',
                ]),
            ];
        }

        return false;
    }

    public function availableColumns()
    {
        return config('data_table.tag.columns');
    }

    public function filterableColumns(): array
    {
        return collect($this->availableColumns())->where('filterable', 1)->pluck('data_name')->all();
    }

    public function generalFilterableColumns(): array
    {
        return ['name'];
    }

    public function sortableColumns()
    {
        return collect($this->availableColumns())->where('sortable', 1)->pluck('data_name')->all();
    }
}
