<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

/**
 * Class Webhook.
 *
 * @property int $integration_instance_id
 * @property int $shopify_webhook_id
 * @property string $address
 * @property string $topic
 * @property array $json_data
 */
class ShopifyWebhook extends Model
{
    protected $table = 'shopify_webhooks';

    protected $fillable = ['integration_instance_id', 'json_data'];

    protected $casts = ['json_data' => 'array'];

    private static $webhooks;

    const TOPIC_INVENTORY_ITEMS_DELETE = 'inventory_items/delete';

    const TOPIC_INVENTORY_ITEMS_UPDATE = 'inventory_items/update';

    const TOPIC_PRODUCTS_CREATE = 'products/create';

    const TOPIC_ORDERS_CREATE = 'orders/create';

    const TOPIC_ORDERS_UPDATED = 'orders/updated';

    const TOPIC_ORDER_TRANSACTIONS_CREATE = 'order_transactions/create';

    /**
     * @return Collection|static[]
     */
    public static function getWebhooks(int $integrationInstanceId, bool $refresh = false)
    {
        if (! isset(static::$webhooks[$integrationInstanceId]) || $refresh) {
            static::$webhooks[$integrationInstanceId] = static::query()->where('integration_instance_id', $integrationInstanceId)->get();
        }

        return static::$webhooks[$integrationInstanceId];
    }

    public static function hasInventoryLevelUpdateWebhook(int $integrationInstanceId, bool $refreshWebhooksFromDB = false): bool
    {
        return static::getWebhooks($integrationInstanceId, $refreshWebhooksFromDB)
            ->where('topic', static::TOPIC_INVENTORY_ITEMS_UPDATE)
            ->isNotEmpty();
    }
}
