<?php

namespace App\Models\Shopify;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * @property int $id
 * @property int $shopify_order_id
 * @property string $line_id
 * @property string $line_type
 * @property int $quantity
 * @property Carbon $processed_at
 * @property int|null $no_restock_fulfillments_applied
 * @property string $link_type
 * @property string|int|mixed $link_id
 * @property string $sku_link_type
 * @property int $sku_link_id
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @property-read ShopifyOrder $shopifyOrder
 * @property-read Model $skuLink
 */
class ShopifyOrderMapping extends Model
{
    const LINK_TYPE_FULFILLMENTS = 'fulfillments';

    const LINK_TYPE_REFUNDS = 'refunds';

    const LINE_TYPE_REFUND_ADJUSTMENT = 'refund_adjustment';

    const LINE_TYPE_LINE_ITEM = 'line_item';

    const SKU_LINK_TYPE_CANCELLATION = 'cancellation';

    protected $fillable = [
        'line_id',
        'line_type',
        'quantity',
        'processed_at',
        'no_restock_fulfillments_applied',
        'link_type',
        'link_id',
        'sku_link_id',
        'sku_link_type',
        'shopify_order_id',
    ];

    public function setProcessedAtAttribute($date)
    {
        $this->attributes['processed_at'] = Carbon::parse($date, 'UTC');
    }

    public function shopifyOrder(): BelongsTo
    {
        return $this->belongsTo(ShopifyOrder::class, 'shopify_order_id');
    }

    public function skuLink(): MorphTo
    {
        return $this->morphTo('sku_link');
    }
}
