<?php

namespace App\Models\Shopify;

use App\Models\SalesOrderLine;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ShopifyOrderLineItem extends Model
{
    use HasFactory;

    protected $table = 'shopify_order_line_items';

    protected $fillable = [
        'shopify_order_id',
        'line_item',
    ];

    protected $casts = [
        'shopify_order_id' => 'integer',
        'line_id' => 'integer',
        'line_item' => 'array',
        'variant_id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function order()
    {
        return $this->belongsTo(\App\Models\Shopify\ShopifyOrder::class);
    }

    /**
     * when using this relation you should add another condition to check the correct line(by order id or by sales channel id)
     */
    public function salesOrderLine(): HasOne
    {
        return $this->hasOne(SalesOrderLine::class, 'sales_channel_line_id', 'line_id');
    }

    public function salesChannelProductSkuColumn()
    {
        return 'variant_id';
    }

    public static function getUniqueId(): string
    {
        return 'line_id';
    }
}
