<?php

namespace App\Models\Shopify;

use App\Enums\Shopify\ShopifyBulkOperationStatusEnum;
use App\Enums\Shopify\ShopifyBulkOperationTypeEnum;
use App\Models\IntegrationInstance;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property string $admin_graphql_api_id
 * @property string $status
 * @property ShopifyBulkOperationTypeEnum $operation_type
 * @property string $type
 * @property int $object_count
 * @property int $file_size
 * @property string|null $token
 * @property string|null $url
 * @property string|null $partial_data_url
 * @property string|null $error_code
 * @property string|null $filename
 * @property string|null $reformatted_filename
 * @property Carbon|null $completed_at
 * @property Carbon $created_at
 * @property Carbon|null $updated_at
 * @property IntegrationInstance $integrationInstance
 */
class ShopifyBulkOperation extends Model
{
    use HasFactory;

    protected $table = 'shopify_bulk_operations';

    protected $fillable = [
        'integration_instance_id',
        'admin_graphql_api_id',
        'status',
        'operation_type',
        'type',
        'object_count',
        'file_size',
        'token',
        'url',
        'partial_data_url',
        'error_code',
        'filename',
        'completed_at',
        'created_at',
    ];

    protected $casts = [
        'status' => ShopifyBulkOperationStatusEnum::class,
        'operation_type' => ShopifyBulkOperationTypeEnum::class,
    ];

    /**
     * Relations
     */
    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(IntegrationInstance::class);
    }
}
