<?php

namespace App\Models;

use App\Models\ShipStation\ShipstationWarehouse;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * @property-read int $id
 * @property int $warehouse_id
 * @property int $provider_id
 * @property string $provider_type
 * @property Warehouse $warehouse
 * @property ShipstationWarehouse|Model $provider
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class ShippingProviderWarehouseMapping extends Model
{
    use HasFactory;

    protected $fillable = [
        'warehouse_id',
        'provider_id',
        'provider_type'
    ];

    public function warehouse(): BelongsTo{
        return $this->belongsTo(Warehouse::class);
    }
    public function provider(): MorphTo{
        return $this->morphTo('provider');
    }
}
