<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ShippingProvider.
 *
 *
 * @property int $id
 * @property string $name
 * @property string $type
 * @property string $warehouse_ids
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ShippingProvider extends Model
{
    const TYPE_DIRECT = 'Direct';

    const TYPE_3PL = '3PL';

    const TYPES = [
        self::TYPE_DIRECT,
        self::TYPE_3PL,
    ];

    protected $fillable = ['name', 'type', 'warehouse_ids'];

    protected $hidden = ['created_at', 'updated_at'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function salesOrderFulfillments()
    {
        return $this->hasMany(SalesOrderFulfillment::class);
    }

    public function salesOrders()
    {
        return $this->belongsToMany(SalesOrder::class, 'sales_order_fulfillments');
    }

    /*
    |--------------------------------------------------------------------------
    | Accessors & Mutators
    |--------------------------------------------------------------------------
    */

    public function setWarehouseIdsAttribute($value)
    {
        if (is_array($value)) {
            $value = implode(',', $value);
        }

        $this->attributes['warehouse_ids'] = $value;
    }

    public function getWarehouseIdsAttribute()
    {
        return explode(',', $this->attributes['warehouse_ids']);
    }
}
