<?php

namespace App\Models\ShipStation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

/**
 * Class Webhook.
 *
 * @property int $integration_instance_id
 * @property int $shipstation_webhook_id
 * @property string $target_url
 * @property string $event
 * @property array $json_data
 */
class Webhook extends Model
{
    protected $table = 'shipstation_webhooks';

    protected $fillable = ['integration_instance_id', 'json_data'];

    protected $casts = ['json_data' => 'array'];

    private static $webhooks;

    const TYPE_SHIP_NOTIFY = 'SHIP_NOTIFY';

    const TYPE_ITEM_SHIP_NOTIFY = 'ITEM_SHIP_NOTIFY';

    const TYPE_ORDER_NOTIFY = 'ORDER_NOTIFY';

    const TYPE_ITEM_ORDER_NOTIFY = 'ITEM_ORDER_NOTIFY';

    /**
     * @return Collection|static[]
     */
    public static function getWebhooks(int $integrationInstanceId, bool $refresh = false)
    {
        if (! isset(static::$webhooks[$integrationInstanceId]) || $refresh) {
            static::$webhooks[$integrationInstanceId] = static::query()->where('integration_instance_id', $integrationInstanceId)->get();
        }

        return static::$webhooks[$integrationInstanceId];
    }
}
