<?php

namespace App\Models;

use App\Models\Concerns\BulkImport;
use App\Models\Concerns\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphPivot;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Spatie\Activitylog\LogOptions;

/**
 * Class SalesOrderLineLayer.
 *
 * @property int $id
 * @property int $sales_order_line_id
 * @property int $quantity
 * @property int $layer_id
 * @property string $layer_type
 */
class SalesOrderLineLayer extends MorphPivot
{
    use BulkImport;
    use LogsActivity;


    /*
    |--------------------------------------------------------------------------
    | Implementers
    |--------------------------------------------------------------------------
    */

    public $incrementing = true;

    protected $fillable = ['sales_order_line_id', 'quantity', 'layer_id', 'layer_type'];

    protected $casts = ['quantity' => 'integer'];

    protected $table = 'sales_order_line_layers';

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['updated_at'])
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs();
    }

    public function getMetadataForActivityLog(): ?array
    {
        return [];
    }

    public function getParentSubjectIdForActivityLog(): int
    {
        return $this->salesOrderLine->sales_order_id;
    }

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function salesOrderLine(): BelongsTo
    {
        return $this->belongsTo(SalesOrderLine::class);
    }

    public function layer(): MorphTo
    {
        return $this->morphTo('layer');
    }
}
