<?php

namespace App\Models;

use App\Enums\SalesChannelProductTemplateFieldTypeEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $sales_channel_product_template_id
 * @property int $sales_channel_field_definition_id
 * @property string|array $default_value
 * @property SalesChannelProductTemplateFieldTypeEnum $type
 * @property Carbon $created_at
 * @property Carbon|null $updated_at
 *
 * @property-read SalesChannelProductTemplate $salesChannelProductTemplate
 * @property-read SalesChannelFieldDefinition $salesChannelFieldDefinition
 */
class SalesChannelProductTemplateField extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'default_value' => 'array',
        'type' => SalesChannelProductTemplateFieldTypeEnum::class,
    ];

    public function salesChannelProductTemplate(): BelongsTo
    {
        return $this->belongsTo(SalesChannelProductTemplate::class);
    }

    public function salesChannelFieldDefinition(): BelongsTo
    {
        return $this->belongsTo(SalesChannelFieldDefinition::class);
    }
}
