<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $sales_channel_id
 * @property string $name
 * @property Carbon $created_at
 * @property Carbon|null $updated_at
 *
 * @property-read SalesChannel $salesChannel
 * @property-read SalesChannelProductTemplateField[] $fields
 */
class SalesChannelProductTemplate extends Model
{
    use HasFactory;

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function salesChannel(): BelongsTo
    {
        return $this->belongsTo(SalesChannel::class);
    }

    public function fields(): HasMany
    {
        return $this->hasMany(SalesChannelProductTemplateField::class);
    }
}
