<?php

namespace App\Models;

use App\Enums\SalesChannelFieldDefinitionDataTypeEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $integration_id
 * @property string $field_name
 * @property SalesChannelFieldDefinitionDataTypeEnum $data_type
 * @property string|array $validation_rules
 * @property int $sort_order
 * @property Carbon $created_at
 * @property Carbon|null $updated_at
 *
 * @property-read Integration $integration
 */
class SalesChannelFieldDefinition extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'data_type' => SalesChannelFieldDefinitionDataTypeEnum::class,
        'validation_rules' => 'array',
    ];

    public function integration(): BelongsTo
    {
        return $this->belongsTo(Integration::class);
    }
}
