<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * Class ProductToCategory.
 *
 *
 * @property int $id
 * @property int $product_id
 * @property int $category_id
 * @property bool $is_primary
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ProductToCategory extends Pivot
{
    protected $table = 'product_to_categories';

    protected $fillable = ['product_id', 'category_id', 'is_primary'];

    protected $casts = ['is_primary' => 'boolean'];

    protected $touches = ['product'];

    public $incrementing = true;

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function productCategory()
    {
        return $this->belongsTo(ProductCategory::class, 'category_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
