<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductListing.
 *
 *
 * Class ProductListingInventory.
 *
 * @property int $id
 * @property int $product_listing_id
 * @property int $sales_channel_qty
 * @property int $sales_channel_location_id
 * @property string $minRuleType
 * @property array $selectedWarehouses
 * @property int $maxRuleType
 * @property int $maxRuleTypeValue
 * @property int $minRuleTypeValue
 * @property array|null $inventory_rules
 * @property bool $subtract_buffer_stock
 * @property int $fulfillment_latency
 * @property int $quantity
 * @property bool $master_of_stock
 * @property ProductListing $productListing - The related product listing.
 */
class ProductListingInventoryLocation extends Model
{
    use HasFactory;

    protected $table = 'product_listing_inventory_locations';

    protected $guarded = [];

    protected $casts
        = [
            'maxRuleTypeValue' => 'integer',
            'minRuleTypeValue' => 'integer',
            'subtract_buffer_stock' => 'boolean',
            'inventory_rules' => 'array',
            'fulfillment_latency' => 'integer',
            'quantity' => 'int',
            'sales_channel_qty' => 'int',
        ];

    public function save(array $options = [])
    {
        return parent::save($options);
    }

    public function productListing()
    {
        return $this->belongsTo(ProductListing::class, 'product_listing_id');
    }
}
