<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property int $sales_channel_id
 * @property string $sales_channel_method
 * @property int|null $payment_type_id
 * @property-read paymentType|null $paymentType
 */
class PaymentMethodMappingSalesChannelToSku extends Model
{
    use HasFactory;

    protected $table = 'payment_method_mappings_sales_channel_to_sku';

    protected $fillable = ['sales_channel_id', 'sales_channel_method'];

    public function salesChannel()
    {
        return $this->belongsTo(SalesChannel::class);
    }

    public function paymentType()
    {
        return $this->belongsTo(PaymentType::class);
    }
}
