<?php

namespace App\Models;

use App\Abstractions\HasNotesInterface;
use App\Abstractions\UniqueFieldsInterface;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * @property string $id
 * @property int $link_id
 * @property string $link_type
 * @property int $user_id
 * @property array $note
 * @property Carbon $created_at
 * @property-read HasNotesInterface $link
 */
class Note extends Model implements UniqueFieldsInterface
{
    use HasFactory;

    protected $table = 'notes';

    public $timestamps = false;

    protected $fillable = [
        'link_type',
        'link_id',
        'note',
        'created_at',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public static function getUniqueFields(): array
    {
        return [
            'link_id',
            'link_type',
            'note',
        ];
    }


    public function save(array $options = []): bool
    {
        // Set default value for "user_id" and "created_at" attributes.
        if (empty($this->attributes['user_id'])) {
            $this->attributes['user_id'] = auth()->id() ?? null;
        }

        if (empty($this->attributes['created_at'])) {
            $this->created_at = now();
        }

        return parent::save($options);
    }

    public function link(): MorphTo
    {
        return $this->morphTo();
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
