<?php

namespace App\Models\Magento;

use App\Models\IntegrationInstance;
use App\Models\ProductPricingTier;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property int $customer_group_id
 * @property int $integration_instance_id
 * @property string $code
 * @property int|null $tax_class_id
 * @property string|null $tax_class_name
 * @property int $product_pricing_tier_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read ProductPricingTier|null $productPricingTier
 */
class CustomerGroup extends Model
{
    use HasFactory;

    protected $table = 'magento_customer_groups';

    protected $fillable = [
        'customer_group_id',
        'integration_instance_id',
        'code',
        'tax_class_id',
        'tax_class_name',
        'product_pricing_tier_id',
    ];

    public function integrationInstance()
    {
        return $this->belongsTo(IntegrationInstance::class);
    }

    public function productPricingTier()
    {
        return $this->belongsTo(ProductPricingTier::class);
    }
}
