<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class InventoryForecastSummary.
 *
 * @property-read int $id
 * @property int $days_of_sales_history
 * @property int $max_projection_days
 * @property int $supplier_id
 * @property ?int $leadtime
 * @property ?int $minimum_order_quantity
 * @property Carbon $forecast_date
 * @property Supplier $supplier
 * @property-read HasMany|InventoryForecastItem[] $inventoryForecastItems
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class InventoryForecast extends Model
{

    use HasFactory;

    /**
     * @var array
     */
    protected $guarded = [];

    public function inventoryForecastItems(): HasMany{
        return $this->hasMany(InventoryForecastItem::class);
    }

    public function supplier(): BelongsTo{
        return $this->belongsTo(Supplier::class);
    }
}
