<?php

namespace App\Models;

use App\Models\Amazon\InboundShipment;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * TODO: If we want to move the link between amazon fba inbound shipments and Warehouse Transfers / Purchase Orders
 *  outside of the Inbounds table, we can use this model to do so.  For now, we are use sku_link within the Inbounds
 * Class InboundShipmentRelation.
 *
 * @deprecated use InboundShipment::sku_link instead
 *
 * @property-read int $id
 * @property string $shipment_id;
 * @property string $link_type;
 * @property int $link_id;
 * @property Carbon $created_at;
 * @property Carbon $updated_at;
 * @property-read PurchaseOrder | WarehouseTransfer $link
 */
class InboundShipmentRelation extends Model
{
    protected $fillable = ['shipment_id', 'link_type', 'link_id', 'integration_instance_id'];

    public function link()
    {
        return $this->morphTo();
    }

    public function delete()
    {
        // Delete shipment id.
        InboundShipment::with([])->where('ShipmentId', $this->shipment_id)->delete();

        return parent::delete();
    }
}
