<?php

namespace App\Models;

use App\Enums\FinancialAllocatableTypeEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * @property int $id
 * @property FinancialAllocatableTypeEnum $allocatable_type
 * @property int $allocatable_from_id
 * @property string $allocatable_from_type
 * @property int $allocatable_to_id
 * @property string $allocatable_to_type
 * @property float $amount
 * @property ?Carbon $created_at
 * @property ?Carbon $updated_at
 */
class FinancialAllocatable extends Pivot
{
    use HasFactory;

    protected $table = 'financial_allocatables';

    protected $guarded = [];

    protected $casts = [
        'allocatable_type' => FinancialAllocatableTypeEnum::class,
    ];

    public function allocatableFrom(): MorphTo
    {
        return $this->morphTo();
    }

    public function allocatableTo(): MorphTo
    {
        return $this->morphTo();
    }
}
