<?php

namespace App\Models;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DataImportMapping.
 *
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property string $model
 * @property array|null mapping
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class DataImportMapping extends Model implements Filterable
{
    use HasFactory, HasFilters;

    /**
     * @var string
     */
    protected $table = 'import_last_mapping';

    protected $fillable = ['integration_instance_id', 'model', 'mapping'];

    protected $casts = [
        'mapping' => 'array',
    ];

    public function integrationInstance()
    {
        return $this->belongsTo(IntegrationInstance::class);
    }

    /**
     * @return DataImportMapping|Builder|\Illuminate\Database\Eloquent\Model|null
     */
    public static function setForModel($model, array $mapping, array $meta = [])
    {
        if (empty($mapping) || ! $model) {
            return null;
        }
        $mapping = self::with([])->updateOrCreate(array_merge(['model' => $model], $meta), [
            'model' => $model,
            'mapping' => $mapping,
        ]);

        foreach ($meta as $key => $value) {
            $mapping[$key] = $value;
        }

        $mapping->save();

        return $mapping;
    }

    public function availableColumns()
    {
        return ['model', 'integration_instance_id'];
    }

    public function filterableColumns(): array
    {
        return $this->availableColumns();
    }

    public function generalFilterableColumns(): array
    {
        return $this->availableColumns();
    }
}
