<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DataFeedTemplate.
 *
 *
 * @property int $id
 * @property string $name
 * @property string $type
 * @property string $data_direction
 * @property array|null $connection_type
 * @property array|null $field_settings
 * @property array|null $filters
 * @property Carbon|null $archived_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class DataFeedTemplate extends Model
{
    /**
     * DataFeed Connection Types.
     */
    const CONNECTION_TYPE_UPLOAD_FILE = 'upload_file';

    const CONNECTION_TYPE_DOWNLOAD_FILE = 'download_file';

    const CONNECTION_TYPE_FTP_DOWNLOAD = 'ftp_download';

    const CONNECTION_TYPE_GOOGLE_SHEETS = 'google_sheets';

    const CONNECTION_TYPE_REST_API = 'rest_api';

    const CONNECTION_TYPE_DOWNLOADED_FILE = 'downloadable_file';

    const CONNECTION_TYPES = [self::CONNECTION_TYPE_UPLOAD_FILE, self::CONNECTION_TYPE_DOWNLOAD_FILE, self::CONNECTION_TYPE_FTP_DOWNLOAD, self::CONNECTION_TYPE_GOOGLE_SHEETS, self::CONNECTION_TYPE_REST_API, self::CONNECTION_TYPE_REST_API, self::CONNECTION_TYPE_DOWNLOADED_FILE];

    /**
     * DataFeed Types.
     */
    const TYPE_PRODUCT_FEED = 'product_feed';

    const TYPES = [self::TYPE_PRODUCT_FEED];

    /**
     * DataFeed Data Direction.
     */
    const DATA_DIRECTION_IMPORT = 'import';

    const DATA_DIRECTION_EXPORT = 'export';

    const DATA_DIRECTIONS = [self::DATA_DIRECTION_IMPORT, self::DATA_DIRECTION_EXPORT];

    protected $fillable = [
        'name',
        'type',
        'data_direction',
        'connection_type',
        'connection_settings',
        'field_settings',
        'filters',
    ];

    protected $casts = [
        'name' => 'string',
        'connection_settings' => 'array',
        'field_settings' => 'array',
        'filters' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'archieved_at' => 'datetime',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'archived_at',
    ];
}
