<?php

namespace App\Models;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Collection;

/**
 * @property int $id
 * @property string $name
 * @property string $link_type
 * @property ?Carbon $archived_at
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property-read Collection|CustomFieldValue[] $customFieldValues
 */
class CustomField extends Model implements Filterable
{
    use HasFactory;
    use HasFilters;

    const FIELD_NONE = 'none';

    protected $guarded = [];

    protected $casts = [
        'archived_at' => 'datetime',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function customFieldValues(): HasMany
    {
        return $this->hasMany(CustomFieldValue::class);
    }

    public function availableColumns()
    {
        return config('data_table.custom_field.columns');
    }

    public function filterableColumns(): array
    {
        return collect($this->availableColumns())->where('filterable', 1)->pluck('data_name')->all();
    }

    public function generalFilterableColumns(): array
    {
        return ['name'];
    }
}
