<?php

namespace App\Models\Constant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ConstantsState extends Model
{
    protected $table = 'constants_states';

    public $timestamps = false;

    protected $fillable = [
        'name',
        'country_code',
        'code',
    ];

    protected $casts = [
        'name' => 'string',
        'country_code' => 'string',
        'code' => 'string',
    ];

    public function country(): BelongsTo
    {
        return $this->belongsTo(ConstantsCountry::class, 'country_code', 'code');
    }
}
