<?php

namespace App\Models\Constant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class ConstantsCountry.
 *
 *
 * @property string $code
 * @property string $name
 * @property int $phone_code
 * @property string $continent_name
 * @property string $continent_code
 */
class ConstantsCountry extends Model
{
    protected $table = 'constants_countries';

    public $timestamps = false;

    protected $fillable = [
        'code',
        'name',
        'phone_code',
        'continent_name',
        'continent_code',
    ];

    public function states(): HasMany
    {
        return $this->hasMany(ConstantsState::class, 'country_code', 'code');
    }

    public function zips(): HasMany
    {
        return $this->hasMany(ConstantsZipcode::class, 'country_code', 'code');
    }

    public function children(): HasMany
    {
        return $this->hasMany(self::class, 'continent_name');
    }
}
