<?php

namespace App\Models\Concerns;

use App\Enums\FinancialLineClassificationEnum;
use App\Models\SalesOrder;
use App\Models\TaxRate;

trait TaxRateTrait
{
    public function taxRate()
    {
        return $this->belongsTo(TaxRate::class);
    }

    public function getTotalAttribute(): float
    {
        $total = $this->orderLines->sum('subtotal');

        if (! $this->is_tax_included) {
            $total = $total + $this->calculated_tax_total;
        }

        if($this->financialLines?->isNotEmpty()){
            // Add total extended amounts for revenue financial lines
            $total += $this->financialLines
                ->where('financialLineType.classification', FinancialLineClassificationEnum::REVENUE)
                ->sum('extended_amount');

            // Add total tax allocations for revenue financial lines
            $total += $this->financialLines
                ->where('financialLineType.classification', FinancialLineClassificationEnum::REVENUE)
                ->sum('tax_allocation');
        }

        if ($this instanceof SalesOrder) {
            $total -= $this->calculated_discount_total;
        }

        return round($total, 2);
    }

    public function getTaxAmount($is_tax_included, $total, $tax_rate)
    {
        return $is_tax_included ? $total - ($total / (1 + ($tax_rate / 100))) : ($total * ($tax_rate / 100));
    }

    public function getTaxCostAttribute()
    {
        return $this->calculated_tax_total;
    }

    public function getCalculatedTaxTotalAttribute()
    {
        // Not sure why this was added in the first place.  But it causes problems if updating an existing sales order line tax rate to 0 for example.
//        if ((float) $this->tax_total > 0) {
//            return $this->tax_total;
//        }

        $totalTax = 0;
        if ($this->tax_rate_id) {
            $totalTax = $this->getTaxAmount($this->is_tax_included, $this->subtotal, $this->taxRate->rate);
        } else {
            foreach ($this->orderLines as $orderLine) {
                if ($orderLine->tax_rate_id) {
                    $totalTax += $this->getTaxAmount($this->is_tax_included, $orderLine->subtotal, $orderLine->taxRate->rate);
                }
            }
        }

        return round($totalTax, 2);
    }

    public function getSubtotalAttribute()
    {
        $subtotal = 0;
        foreach ($this->productLines as $orderLine) {
            $subtotal += $orderLine->quantity * $orderLine->amount;
        }

        return $subtotal;
    }
}
