<?php

namespace App\Models\Concerns;

use App\Repositories\ActivityRepository;
use Spatie\Activitylog\Models\Activity;

trait LogsActivity
{
    use \Spatie\Activitylog\Traits\LogsActivity;

    /**
     * Retrieve the parent subject id of the model
     * add the class' model to @see ActivityRepository::getSubSubjectTypes
     */
    abstract public function getParentSubjectIdForActivityLog(): int;

    /**
     * Retrieve the metadata of the model
     */
    abstract public function getMetadataForActivityLog(): ?array;

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->properties = $activity->properties->put('metadata', $this->getMetadataForActivityLog());
        $activity->parent_subject_id = $this->getParentSubjectIdForActivityLog();
    }
}
