<?php

namespace App\Models\Concerns;

use App\Models\JobPayload;

trait HasJobPayload
{
    /**
     * Get the uuid used for storing the payload in jobs table.
     *
     * @throws \InvalidArgumentException
     */
    private function getUuid(): string
    {
        if (config('queue.default') === 'sync') {
            return $this->job->payload()['uuid'];
        } else {
            return $this->job->getJobId();
        }
    }

    /**
     * Save job payload in jobs table.
     *
     * @throws \InvalidArgumentException
     */
    public function saveJobPayload(array $payload): void
    {
        JobPayload::updateOrCreate([
            'uuid' => $this->getUuid(),
        ], [
            'uuid' => $this->getUuid(),
            'payload' => $payload,
        ]);
    }

    /**
     * @return mixed
     *
     * @throws \InvalidArgumentException
     */
    public function getJobPayload()
    {
        return JobPayload::find($this->getUuid());
    }

    /**
     * @throws \InvalidArgumentException
     */
    public function deleteJobPayload(): void
    {
        JobPayload::where('uuid', $this->getUuid())->delete();
    }
}
