<?php

namespace App\Models\Concerns;

use App\Models\CustomFieldValue;
use App\Repositories\CustomFieldValueRepository;
use Illuminate\Database\Eloquent\Relations\MorphMany;

trait HasCustomFields
{
    public function customFieldValues(): MorphMany
    {
        return $this->morphMany(CustomFieldValue::class, 'link');
    }

    public function syncCustomFieldValues(array $custom_field_values): void
    {
        app(CustomFieldValueRepository::class)->syncCustomFieldValues($this, $custom_field_values);
    }
}
