<?php

namespace App\Models\Concerns;

use App\Models\Currency;

trait HasCurrencyAttributes
{
    public static $useDefaultCurrency = false;

    /**
     * The model's attributes that will return value as the default currency.
     * Define the property in the model(we can't define in the trait and class in the same time).
     *
     * @var array
     */
    //    protected $currencyAttributes = [];

    public function getAttributeValue($key)
    {
        $value = parent::getAttributeValue($key);

        if (static::$useDefaultCurrency && in_array($key, $this->currencyAttributes)) {
            return $value / $this->getTransactionCurrency()->conversion;
        }

        return $value;
    }

    /**
     * Whether to use the default currency or not.
     */
    public static function useDefaultCurrency(bool $use = true)
    {
        static::$useDefaultCurrency = $use;
    }

    /**
     * Get The transaction currency.
     */
    abstract public function getTransactionCurrency(): Currency;
}
