<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class AttributeValue.
 *
 *
 * @property int $id
 * @property int $attribute_id
 * @property string $value
 * @property int $sort_order
 * @property Attribute $attribute
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class AttributeValue extends Model
{
    protected $fillable = ['value', 'sort_order'];

    public function attribute()
    {
        return $this->belongsTo(Attribute::class);
    }

    public function getValueAttribute()
    {
        if ($this->attribute->type === Attribute::TYPE_NUMERIC) {
            $validation = $this->attribute->validation;
            if ($validation && isset($validation['precision'])) {
                return number_format($this->attributes['value'], $validation['precision']);
            }
        }

        return $this->attributes['value'];
    }
}
