<?php

namespace App\Managers;

use Carbon\Carbon;
use Cron\CronExpression;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Console\Scheduling\Schedule;

class ScheduleManager
{
    public function __construct(private readonly Schedule $schedule)
    {
    }

    /**
     * @throws Exception
     */
    public function commandNextSchedule(Command $command, $parameterString = null): ?Carbon
    {
        $commandString = $command->getName() . ($parameterString ? ' ' . $parameterString : '');
        foreach ($this->schedule->events() as $event)
        {
            if (str_contains($event->command, $commandString)) {
                $cron = new CronExpression($event->expression);
                return Carbon::instance($cron->getNextRunDate());
            }
        }
        return null;
    }
}