<?php

namespace App\Managers;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Enums\IntegrationInstanceSyncStatusEnum;
use App\Models\IntegrationInstance;
use App\Notifications\IntegrationInstanceSyncStatusInactiveNotification;
use App\Repositories\IntegrationInstanceRepository;
use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Notification;

class IntegrationInstanceManager
{
    public function __construct(private readonly IntegrationInstanceRepository $instances, private readonly UserRepository $users)
    {
    }

    public function updateSyncStatus(IntegrationInstance|IntegrationInstanceInterface $integrationInstance, IntegrationInstanceSyncStatusEnum $syncStatus): void
    {
        $this->instances->updateSyncStatus($integrationInstance, $syncStatus);
        if ($syncStatus === IntegrationInstanceSyncStatusEnum::INACTIVE) {
            Notification::send($this->users->getAdminUsers(), new IntegrationInstanceSyncStatusInactiveNotification($integrationInstance));
        }
    }
}
