<?php

namespace App\Listeners;

use App\Events\GoodsReceived;
use App\Models\PurchaseOrder;

class UpdatePurchaseOrderStatus
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(GoodsReceived $event): void
    {
        $fulfilled = true;

        foreach ($event->purchaseOrder->purchaseOrderLines as $purchaseOrderLine) {
            $inventoryMovement = $purchaseOrderLine->inventoryMovement;

            if (! $inventoryMovement || $purchaseOrderLine->quantity < $inventoryMovement->quantity) {
                $fulfilled = false;
            }
        }

        if ($fulfilled) {
            $event->purchaseOrder->update(['status' => PurchaseOrder::STATUS_FULFILLED]);
        } else {
            $event->purchaseOrder->update(['status' => PurchaseOrder::STATUS_PARTIALLY_DELIVERED]);
        }
    }
}
