<?php

namespace App\Listeners;

use App\Models\UserAlertSetting;
use App\Notifications\PurchaseOrderSent;
use App\Notifications\SubmitPurchaseOrderToSupplierNotification;
use Exception;
use Illuminate\Support\Facades\Notification;

class SendPurchaseOrderToSupplier
{
    protected $notify = true;

    protected $alertType = UserAlertSetting::ALERT_TYPE_PO_SENT;

    /**
     * Handle the event.
     *
     *
     * @throws Exception
     */
    public function handle(object $event): void
    {
        if ($event->notifySupplier) {
            Notification::send($event->purchaseOrder->supplier, new SubmitPurchaseOrderToSupplierNotification($event->purchaseOrder));

            parent::handle($event);
        }
    }

    /**
     * Get notification instance.
     */
    public function getNotification($event): \Illuminate\Notifications\Notification
    {
        return new PurchaseOrderSent($event->purchaseOrder);
    }
}
