<?php

namespace App\Lib\DataList;

use League\Csv\CharsetConverter;
use League\Csv\Reader;

/**
 * Wrapper for https://github.com/thephpleague/csv
 */
class LeagueCsvDataList implements DataListInterface
{
    protected Reader $csv;

    public function __construct(
        string $fileName,
        ?string $alternativeDelimiter = null
    ) {
        $this->csv = Reader::createFromPath($fileName, 'r');
        $this->csv->setHeaderOffset(0);

        if ($alternativeDelimiter) {
            $this->csv->setDelimiter($alternativeDelimiter);
        }

        $inputBom = $this->csv->getInputBOM();

        if ($inputBom === Reader::BOM_UTF16_LE || $inputBom === Reader::BOM_UTF16_BE) {
            CharsetConverter::addTo($this->csv, 'utf-16', 'utf-8');
        }
    }

    public function getColumnHeadings(): array
    {
        return DataListHelper::trimArray($this->csv->getHeader());
    }

    public function getRows(): \Generator
    {
        foreach ($this->csv->getRecords($this->getColumnHeadings()) as $record) {
            yield DataListHelper::trimArray($record);
        }
    }

    public function getRowCount(): int
    {
        return $this->csv->count();
    }
}
