<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\ShipMyOrders\Managers\ShipMyOrdersOrderManager;

class UpdateSMOTrackingInfo implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly ShipMyOrdersOrderManager $manager)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): int
    {
        $this->manager->updateTrackingInfo();
        return 0;
    }
}
